<?php


namespace Olympus\Test\Routes;

use Olympus\Routes\Organisation;
use Olympus\Routes\RouteInterface;
use PHPUnit\Framework\TestCase;

class OrganisationTest extends TestCase
{
    public function testCreate()
    {
        $route = Organisation::create();
        $this->assertEquals('/organisations', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::POST_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'name', 'description', 'logo_url', 'owner_id'
        ], $route[RouteInterface::PARAMS_KEY]);
        $this->assertEqualsCanonicalizing([
            'params' => ['name', 'owner_id']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testGet()
    {
        $route = Organisation::get();
        $this->assertEquals('/organisations/{id}', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::GET_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testUpdate()
    {
        $route = Organisation::update();
        $this->assertEquals('/organisations/{id}', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::PUT_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'name', 'description', 'logo_url'
        ], $route[RouteInterface::PARAMS_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id'],
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testInviteUsers()
    {
        $route = Organisation::inviteUsers();
        $this->assertEquals('/organisations/{id}/invites', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::POST_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'members'
        ], $route[RouteInterface::PARAMS_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id'],
            'params' => ['members']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testListMembers()
    {
        $route = Organisation::listMembers();
        $this->assertEquals('/organisations/{id}/members', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::GET_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testRemoveMembers()
    {
        $route = Organisation::removeMembers();
        $this->assertEquals('/organisations/{id}/members/remove', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::POST_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'members'
        ], $route[RouteInterface::PARAMS_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id'],
            'params' => ['members']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testUpdateMembersRoles()
    {
        $route = Organisation::updateMembersRoles();
        $this->assertEquals('/organisations/{id}/members/roles', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::POST_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'members'
        ], $route[RouteInterface::PARAMS_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id'],
            'params' => ['members']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testListMemberInvites()
    {
        $route = Organisation::listMemberInvites();
        $this->assertEquals('/organisations/{id}/invites', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::GET_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testGetSettings()
    {
        $route = Organisation::getSettings();
        $this->assertEquals('/organisations/{id}/settings', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::GET_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testUpdateSettings()
    {
        $route = Organisation::updateSettings();
        $this->assertEquals('/organisations/{id}/settings', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::PUT_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'member_management_access',
            'role_management_access',
            'settings_management_access',
        ], $route[RouteInterface::PARAMS_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id'],
            'params' => ['member_management_access','role_management_access', 'settings_management_access']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testRespondToInvite()
    {
        $route = Organisation::respondToInvite();
        $this->assertEquals('/organisations/invites/respond', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::POST_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'user_id',
            'invite_response',
            'organisation_id',
        ], $route[RouteInterface::PARAMS_KEY]);
        $this->assertEqualsCanonicalizing([
            'params' => ['user_id','organisation_id', 'invite_response']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }
}
