<?php


namespace Olympus\Test\Http;

use Olympus\Helpers\RequestBag;
use Olympus\Http\Caller;
use Olympus\Http\MagicCallerTrait;
use Olympus\Http\Router;
use Olympus\Test\BaseTest;

class MagicCallerTraitTest extends BaseTest
{
    public function testGetMagicMethod()
    {

        $actor = \Mockery::mock(MagicCallerTrait::class)->makePartial();
        $actor->shouldReceive('getCaller')
            ->andReturn(\Mockery::mock(Caller::class));

        $router = $actor->server;

        $this->assertInstanceOf(Router::class, $router);
    }

    public function testAsync()
    {
        $data = (object)[
            'status' => true
        ];

        $caller = \Mockery::mock(Caller::class)->makePartial();
        $caller->shouldReceive('callEndpointAsync')
            ->andReturns([$data, $data]);

        $actor = \Mockery::mock(MagicCallerTrait::class)->makePartial();
        $actor->shouldReceive('getCaller')
            ->andReturn($caller);

        $requests = ['server.healthCheck', ['server.healthCheck', new RequestBag()]];
        $response = $actor->async($requests);

        $this->assertEquals(2, count($response));

        $this->assertEquals($data, $response[0]);
        $this->assertEquals($data, $response[1]);
    }
}
