<?php


namespace Olympus\Test\Exception;


use Olympus\Exception\OlympusException;
use Olympus\Test\BaseTest;
use Psr\Http\Message\ResponseInterface;

class OlympusExceptionTest extends BaseTest
{
    public function testCanThrow()
    {
        $exception = new OlympusException("Something went wrong");

        $this->assertEquals("Something went wrong", $exception->getMessage());
    }

    public function testGetExceptionFromResponse()
    {
        $responseArray = [
            'error' => "Invalid arguments present in request",
            'error_code' => "E101",
            'http_status_code' =>  400
        ];

        $response = \Mockery::mock(ResponseInterface::class);
        $response->shouldReceive('getBody')
            ->andReturn(json_encode($responseArray));

        $response->shouldReceive('getStatusCode')
            ->andReturn(400);

        $exception = OlympusException::fromResponse($response);

        $this->assertEquals($responseArray['error'], $exception->getMessage());

        $exceptionAsArray = $exception->toArray();
        $this->assertEquals($responseArray, $exceptionAsArray);
    }
}
