<?php


namespace Olympus\Test\Actors;


use Olympus\Actors\Client;
use Olympus\Api;
use Olympus\Test\BaseTest;

class ClientTest extends BaseTest
{
    public function testAuthenticate()
    {
        $apiUrl = "http://somedummyapi.com";
        $clientId = "some fake id";
        $clientSecret = "some fake secret";
        $expiresIn = 10000;
        $accessToken = "sometoken";

        $returnData = [
            "data" => [
                "access_token" => $accessToken,
                "expires_in" => $expiresIn
            ]
        ];

        $api = new Api($apiUrl, $clientId, $clientSecret);
        $caller = $this->getCallerMock($returnData);
        $caller->shouldReceive('getActor')
            ->andReturn($api);
        $api->setCaller($caller);

        $client = new Client($api);
        $client->authenticate();

        $this->assertEquals($accessToken, $client->getAccessToken());
        $this->assertNotNull($client->getExpiresAt());

        $diff = time() + $expiresIn - $client->getExpiresAt();
        $this->assertEquals(0, $diff);
    }
}
