# Contributing

## Reporting Errors

All errors should be submitted at the [issue tracker](https://bitbucket.org/mobnia/olympus-sdk/issues) for this project.
The ***kind*** field for the error should be set to ***bug*** 

In order to speed up the debugging process, it is important that as much information as possible is given when reporting
errors.

The template below is recommended:
```markdown
#### Issue description



#### Steps to reproduce the issue

1.  
2. 
3. 


#### What's the expected result?

-


#### What's the actual result?

-


#### Additional details / screenshot

- ![Screenshot]()
-

``` 

## Suggesting Features

Olympus API and this PHP SDK are under active development. Suggestions for features that make the SDK easier to use 
and reduce development time for users of Olympus are welcome.

Please submit a proposal at the [issue tracker](https://bitbucket.org/mobnia/olympus-sdk/issues) and
the ***kind*** field for the error should be set to ***proposal***

## Making Changes

### Setting up Development Environment

The SDK has been tested with PHP 7.2, 7.3 and 7.4. An environment which has any of these versions of PHP should be fine.

To get started:
- clone the repository
- run `composer install` to fetch dependencies
- run `./vendor/bin/phpunit` to run all tests and make sure everything works as it should.

### Adding Features

Every new feature added should at the minimum include a test that makes sure the feature works.
Changes without accompanying tests would not be accepted. 

Also if the new feature requires a documentation update then the appropriate section in the `docs` folder should be
updated.

### Adding New Routes

This would perhaps be the most frequent change to the SDK.

In this case, the route should be added in the `app/Routes` folder. Please see existing route definitions for a template.

The `docs/routes.md` file should also be updated with the added route definition.