<?php

namespace Olympus\Routes;
/**
 * Interface RouteInterface
 * Influenced strongly by https://github.com/yabacon/paystack-php
 * @package Olympus\Routes
 */

interface RouteInterface
{

    const METHOD_KEY = 'method';
    const ENDPOINT_KEY = 'endpoint';
    const PARAMS_KEY = 'params';
    const PATH_KEY = 'path';
    const QUERY_PARAMS_KEY = 'query';
    const DEFAULT_KEY = 'default';
    const REQUIRED_KEY = 'required';
    const POST_METHOD = 'post';
    const PUT_METHOD = 'put';
    const GET_METHOD = 'get';
    const REQUIRES_AUTH = 'auth';
    const ACTOR_UID_MAP = 'uid_map';

    public static function root();
}
