<?php


namespace Olympus\Http;

use Olympus\Exception\OlympusException;

trait MagicCallerTrait
{
    /**
     * @param $name
     * @return Router
     * @throws OlympusException
     */
    public function __get($name)
    {
        return new Router($name, $this->getCaller());
    }

    /**
     * @param array $requests
     * @return mixed
     * @throws OlympusException
     */
    public function async(array $requests)
    {
        $routes = [];
        foreach ($requests as $key => $value)
        {
            $payload = null;
            if (is_string($value)) {
                $routeName = $value;
                $payload = null;
            } elseif (is_array($value) && !empty($value) && count($value) <=2) {
                $routeName = $value[0];
                $payload = isset($value[1]) ? $value[1] : null;
            } else {
                throw new OlympusException("Invalid request definition");
            }

            $routeParts = explode(".", $routeName);
            if (count($routeParts) != 2) {
                throw new OlympusException("${routeName} is not a valid route name");
            }
            list($group, $endpoint) = $routeParts;


            list($group, $groupClass, $methods) = Router::getRouteMethods($group);

            if ($endpoint == "root" || !in_array($endpoint, $methods)) {
                throw new OlympusException("${endpoint} is not a valid endpoint for ${group}");
            }

            $routeDefinition = call_user_func($groupClass . '::' . $endpoint);

            $routes[$key] = [$routeDefinition, $payload];
        }

        $caller = $this->getCaller();

        return $caller->callEndpointAsync($routes);
    }
}
