<?php


namespace Olympus\Helpers;

class Bag implements \ArrayAccess, \JsonSerializable
{
    private $data = [];

    public function __construct($data = null)
    {
        if (is_null($data)) {
            $data = [];
        }

        $this->data =  $data;
    }

    public function offsetExists($offset)
    {
        return isset($this->data[$offset]);
    }

    public function offsetGet($offset)
    {
        return $this->data[$offset];
    }

    public function offsetSet($offset, $value)
    {
        $this->data[$offset] = $value;
    }

    public function offsetUnset($offset)
    {
        unset($this->data[$offset]);
    }

    public function __get($name)
    {
        return $this->data[$name];
    }

    public function __set($name, $value)
    {
        $this->data[$name] = $value;
    }

    public function jsonSerialize()
    {
        return $this->data;
    }

    public function reset($params = [])
    {
        $this->data =  $params;
    }

    public function update($params = [])
    {
        $this->data = array_merge($this->data, $params);
    }
}
