<?php

namespace Olympus\Exception;

use Psr\Http\Message\ResponseInterface as Response;

class OlympusException extends \Exception implements \JsonSerializable
{
    protected $errorMessage;

    protected $errorCode;

    protected $httpStatusCode;

    const DEFAULT_ERROR_MESSAGE = "An error occurred while communicating with the API";

    public function __construct($message = "", $code = 400, $errorCode = null)
    {
        parent::__construct($message, $code, null);

        $this->errorMessage = $message;
        $this->errorCode = $errorCode;
        $this->httpStatusCode = $code;
    }

    public static function fromResponse(Response $response)
    {
        $body = (string) $response->getBody();
        $body = json_decode($body, true);

        if (json_last_error() != JSON_ERROR_NONE || !is_array($body)) {
            return new self(self::DEFAULT_ERROR_MESSAGE, $response->getStatusCode());
        }

        $errorMessage = $body['error'] ?? self::DEFAULT_ERROR_MESSAGE;
        $errorCode = $body['error_code'] ?? null;
        $httpStatusCode = $body['http_status_code'] ?? $response->getStatusCode();

        return new self($errorMessage, $httpStatusCode, $errorCode);
    }

    public function toArray()
    {
        return [
            "error" => $this->errorMessage,
            "error_code" => $this->errorCode,
            "http_status_code" => $this->httpStatusCode
        ];
    }

    public function jsonSerialize()
    {
       return $this->toArray();
    }

    public function getErrorCode()
    {
        return $this->errorCode;
    }

    public function getHttpStatusCode()
    {
        return $this->httpStatusCode;
    }
}
