<?php

namespace Olympus\Actors;

use GuzzleHttp\Exception\GuzzleException;
use Olympus\Exception\OlympusException;
use Olympus\Helpers\RequestBag;
use Olympus\Routes\Auth;

class User extends AbstractActor
{
    const SCOPES = "read write";
    /**
     * @var \StdClass
     */
    protected $userData;
    /**
     * @param array $params
     * @return self
     * @throws GuzzleException
     * @throws OlympusException
     */
    public function authenticate(array $params)
    {

        $authType = $params['auth_type'] ?? null;
        $authParams = $params['auth_params'] ?? null;
        $scopes = $params['scopes'] ?? self::SCOPES;

        $routeInterface = Auth::getUserToken();


        $body = [
            'auth_type' => $authType,
            'auth_params' => $authParams,
            'scopes' => $scopes
        ];

        $payload = new RequestBag([], [], $body);

        $responseData = $this->getApi()->getCaller()->callEndPoint($routeInterface, $payload);
        $responseData = $responseData->data;

        $tokenData = $responseData->token_data;
        $this->userData = $responseData->user;

        $this->accessToken = $tokenData->access_token;
        $this->refreshToken = $tokenData->refresh_token;
        $this->expiresAt = time() + intval($tokenData->expires_in);
        $this->uid = $this->userData->id;
        $this->scopes = $scopes;

        return $this;
    }

    /**
     * @return \StdClass
     */
    public function getAuthUserData()
    {
        return $this->userData;
    }

    /**
     * @throws GuzzleException
     * @throws OlympusException
     */
    protected function refreshAccessToken()
    {
        $routeInterface = Auth::refreshAccessToken();

        $body = [
            'refresh_token' => $this->refreshToken,
            'scopes' => $this->scopes
        ];

        $payload = new RequestBag([], [], $body);

        $responseData = $this->getApi()->getCaller()->callEndPoint($routeInterface, $payload);
        $responseData = $responseData->data;

        $this->accessToken = $responseData->access_token;
        $this->refreshToken = $responseData->refresh_token;
        $this->expiresAt = time() + intval($responseData->expires_in);
    }

    /**
     * @return string|null
     * @throws GuzzleException
     * @throws OlympusException
     */
    public function getAccessToken(): ?string
    {
        if (!$this->accessToken || !$this->expiresAt || !$this->refreshToken) {
            return $this->accessToken;
        }

        if ($this->expiresAt > time()) {
            return $this->accessToken;
        }

        $this->refreshAccessToken();

        return $this->accessToken;
    }

    public function setUserAuthData(object $data)
    {
        $this->userData = $data;
    }
}
