<?php


namespace Olympus\Actors;


use Olympus\Api;
use Olympus\Contracts\CanMakeCall;

interface ActorInterface extends CanMakeCall
{

    public function getExpiresAt(): ?int;

    public function getAccessToken(): ?string;

    public function getRefreshToken(): ?string;

    public function getUid(): ?string;

    public function getApi(): Api;

    public function setApi(Api $api);

    /**
     * @param array $params
     * @return static
     */
    public function authenticate(array $params);
}
