<?php


namespace Olympus\Test\Actors;


use Olympus\Actors\AbstractActor;
use Olympus\Api;
use Olympus\Test\BaseTest;

class AbstractActorTest extends BaseTest
{
    public function testGettersSetters()
    {
        $api = \Mockery::mock(Api::class);
        $accessToken = "sometoken";
        $expiresAt = 12345;
        $uid = 1;
        $refreshToken = "somerefreshToken";

        $actor = \Mockery::mock(AbstractActor::class, [$api])->makePartial();

        $this->assertEquals($api, $actor->getApi());
        $this->assertNull($actor->getAccessToken());
        $this->assertNull($actor->getRefreshToken());
        $this->assertNull($actor->getExpiresAt());
        $this->assertNull($actor->getUid());
        $this->assertNull($actor->getAuthorizationHeader());


        $newActor = \Mockery::mock(AbstractActor::class, [$api, $accessToken, $expiresAt, $uid, $refreshToken])
            ->makePartial();
        $this->assertEquals($accessToken, $newActor->getAccessToken());
        $this->assertEquals($expiresAt, $newActor->getExpiresAt());
        $this->assertEquals($refreshToken, $newActor->getRefreshToken());
        $this->assertEquals($uid, $newActor->getUid());
        $this->assertEquals('Bearer '.$accessToken, $newActor->getAuthorizationHeader());
    }
}
