<?php

namespace Olympus\Routes;

class User implements RouteInterface
{
    public static function root()
    {
        return '/users';
    }

    public static function register()
    {
        return [
            self::METHOD_KEY => self::POST_METHOD,
            self::ENDPOINT_KEY => '/auth/user/register',
            self::PARAMS_KEY => [
                'reg_type',
                'reg_params'
            ],
            self::REQUIRED_KEY => [
                RouteInterface::PARAMS_KEY => [
                    'reg_type',
                    'reg_params'
                ]
            ],
            self::REQUIRES_AUTH => true
        ];
    }

    public static function listUserOrganisations()
    {
        return [
            self::METHOD_KEY => self::GET_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}/organisations',
            self::PATH_KEY => ['id'],
            self::REQUIRED_KEY => [
                RouteInterface::PATH_KEY => [
                    'id'
                ]
            ],
            self::ACTOR_UID_MAP => [
                RouteInterface::PATH_KEY => 'id'
            ]
        ];
    }

    public static function listUserOrganisationInvites()
    {
        return [
            self::METHOD_KEY => self::GET_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}/organisations/invites',
            self::PATH_KEY => ['id'],
            self::REQUIRED_KEY => [
                RouteInterface::PATH_KEY => [
                    'id'
                ]
            ],
            self::ACTOR_UID_MAP => [
                RouteInterface::PATH_KEY => 'id'
            ]
        ];
    }

    public static function getUserProfile()
    {
        return [
            self::METHOD_KEY => self::GET_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}',
            self::PATH_KEY => ['id'],
            self::REQUIRED_KEY => [
                RouteInterface::PATH_KEY => [
                    'id'
                ]
            ],
            self::ACTOR_UID_MAP => [
                RouteInterface::PATH_KEY => 'id'
            ]
        ];
    }

    public static function updateUserProfile()
    {
        return [
            self::METHOD_KEY => self::PUT_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}',
            self::PATH_KEY => ['id'],
            self::PARAMS_KEY => [
                'firstname',
                'lastname',
                'timezone',
                'avatar',
                'date_of_birth'
            ],
            self::REQUIRED_KEY => [
                self::PATH_KEY => [
                    'id'
                ],
            ],
            self::ACTOR_UID_MAP => [
                RouteInterface::PATH_KEY => 'id'
            ]
        ];
    }
}
