<?php

namespace Olympus\Actors;


use GuzzleHttp\Exception\GuzzleException;
use Olympus\Exception\OlympusException;
use Olympus\Helpers\RequestBag;
use Olympus\Routes\Auth;

class Client extends AbstractActor
{
    /**
     * @param array $params
     * @return self
     * @throws GuzzleException
     * @throws OlympusException
     */
    public function authenticate(array $params = [])
    {
        $routeInterface = Auth::getClientToken();
        $payload = new RequestBag();

        $tokenData = $this->getApi()->getCaller()->callEndPoint($routeInterface);
        $tokenData = $tokenData->data;

        $this->accessToken = $tokenData->access_token;
        $this->expiresAt = time() + intval($tokenData->expires_in);

        return $this;
    }

}
