<?php

namespace Olympus\Test\Routes;


use Olympus\Routes\RouteInterface;
use Olympus\Routes\User;
use PHPUnit\Framework\TestCase;

class UserTest extends TestCase
{
    public function testRegister()
    {
        $route = User::register();
        $this->assertEquals('/auth/user/register', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::POST_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'reg_type', 'reg_params',
        ], $route[RouteInterface::PARAMS_KEY]);
        $this->assertEqualsCanonicalizing([
            'params' => ['reg_type', 'reg_params']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testListUserOrganisations()
    {
        $route = User::listUserOrganisations();
        $this->assertEquals('/users/{id}/organisations', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::GET_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testListUserOrganisationInvites()
    {
        $route = User::listUserOrganisationInvites();
        $this->assertEquals('/users/{id}/organisations/invites', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::GET_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testGetUserProfile()
    {
        $route = User::getUserProfile();
        $this->assertEquals('/users/{id}', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::GET_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testUpdateUserProfile()
    {
        $route = User::updateUserProfile();
        $this->assertEquals('/users/{id}', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::PUT_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'id'
        ], $route[RouteInterface::PATH_KEY]);
        $this->assertEqualsCanonicalizing([
            'firstname', 'lastname', 'avatar', 'date_of_birth', 'timezone'
        ], $route[RouteInterface::PARAMS_KEY]);
        $this->assertEqualsCanonicalizing([
            'path' => ['id']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }
}
