<?php


namespace Olympus\Test\Routes;


use Olympus\Routes\Auth;
use Olympus\Routes\RouteInterface;
use PHPUnit\Framework\TestCase;

class AuthTest extends TestCase
{

    public function testGetClientToken()
    {
        $route = Auth::getClientToken();
        $this->assertEquals('/auth/client/token', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::POST_METHOD, $route[RouteInterface::METHOD_KEY]);
    }

    public function testGetUserToken()
    {
        $route = Auth::getUserToken();
        $this->assertEquals('/auth/user/token', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::POST_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'auth_type', 'auth_params', 'scopes'
        ], $route[RouteInterface::PARAMS_KEY]);
        $this->assertEqualsCanonicalizing([
            'params' => ['auth_type', 'auth_params', 'scopes']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testRefreshAccessToken()
    {
        $route = Auth::refreshAccessToken();
        $this->assertEquals('/auth/token/refresh', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::POST_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'refresh_token', 'scopes'
        ], $route[RouteInterface::PARAMS_KEY]);
        $this->assertEqualsCanonicalizing([
            'params' => ['refresh_token', 'scopes']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }

    public function testRevokeAccessToken()
    {
        $route = Auth::revokeAccessToken();
        $this->assertEquals('/auth/token/revoke', $route[RouteInterface::ENDPOINT_KEY]);
        $this->assertEquals(RouteInterface::POST_METHOD, $route[RouteInterface::METHOD_KEY]);
        $this->assertEqualsCanonicalizing([
            'access_token'
        ], $route[RouteInterface::PARAMS_KEY]);
        $this->assertEqualsCanonicalizing([
            'params' => ['access_token']
        ], $route[RouteInterface::REQUIRED_KEY]);
    }
}
