<?php

namespace Olympus\Test\Http;

use Olympus\Http\Caller;
use Olympus\Http\Router;
use Olympus\Test\BaseTest;

class RouterTest extends BaseTest
{
    public function testMagicWorks()
    {
        $data = (object) [
            'application' => "Prowork Olympus",
            'status' => true,
            'version' => "1.0.0"
        ];
        $caller = \Mockery::mock(Caller::class);
        $caller->shouldReceive('callEndpoint')
            ->andReturn($data);

        $router = new Router('server', $caller);

        $response = $router->healthCheck();

        $this->assertEquals($data, $response);
    }
}
