<?php


namespace Olympus\Test\Http;


use GuzzleHttp\Client;
use Olympus\Contracts\CanMakeCall;
use Olympus\Helpers\RequestBag;
use Olympus\Http\Caller;
use Olympus\Test\BaseTest;

class CallerTest extends BaseTest
{
    public function testGetGuzzleClient()
    {
        $actor = \Mockery::mock(CanMakeCall::class);

        $caller = new Caller($actor, 'log');

        $reflection = new \ReflectionClass(Caller::class);
        $method = $reflection->getMethod('getGuzzleClient');
        $method->setAccessible(true);

        $client = $method->invoke($caller);

        $this->assertInstanceOf(Client::class, $client);
    }

    public function testCallEndpoint()
    {
        $return = [
            'id' => 1
        ];

        $authHeader = "Bearer sometoken";
        $url = "http://someurl.com";

        $actor = \Mockery::mock(CanMakeCall::class);
        $actor
            ->shouldReceive('getAuthorizationHeader')
            ->andReturn($authHeader);
        $actor->shouldReceive('getApiUrl')
            ->andReturn($url);

        $caller = \Mockery::mock(Caller::class, [$actor])
            ->makePartial()
            ->shouldAllowMockingProtectedMethods();

        $caller->shouldReceive('getGuzzleClient')
            ->andReturn($this->getGuzzleMock($return));

        $route = [
            'endpoint' => '/',
            'method' => 'get'
        ];
        $payload = new RequestBag();

        $res = $caller->callEndPoint($route, $payload);

        $this->assertEquals((object) $return, $res);
    }
}
