<?php


namespace Olympus\Test;

use GuzzleHttp\Client;
use Mockery\Adapter\Phpunit\MockeryPHPUnitIntegration;
use Olympus\Http\Caller;
use PHPUnit\Framework\TestCase;
use Psr\Http\Message\ResponseInterface;

abstract class BaseTest extends TestCase
{
    use MockeryPHPUnitIntegration;

    public function getCallerMock(array $returnData = [])
    {
        $caller = \Mockery::mock(Caller::class)
            ->shouldAllowMockingProtectedMethods()
            ->makePartial();

        $caller->shouldReceive('getGuzzleClient')
            ->andReturn($this->getGuzzleMock($returnData));

        return $caller;
    }


    public function getGuzzleMock(array $returnData = [])
    {
        $guzzle = \Mockery::mock(Client::class)->makePartial();

        $response = \Mockery::mock(ResponseInterface::class);
        $response->shouldReceive('getBody')
            ->andReturn(json_encode($returnData));

        $guzzle->shouldReceive('send')
            ->andReturn($response);

        return $guzzle;
    }
}
