<?php


namespace Olympus\Test;

use Olympus\Actors\Client;
use Olympus\Actors\User;
use Olympus\Api;

class ApiTest extends BaseTest
{
    public function testInit()
    {
        $apiUrl = "http://somedummyapi.com";
        $clientId = "some fake id";
        $clientSecret = "some fake secret";

        $api = new Api($apiUrl, $clientId, $clientSecret);

        $this->assertEquals($apiUrl, $api->getApiUrl());
        $this->assertEquals($clientId, $api->getClientId());
        $this->assertEquals($clientSecret, $api->getClientSecret());

        $this->assertNull($api->getLogFile());

        $logFile = "test.log";
        $logformat = "some format";

        $api->setLogFile($logFile);
        $api->setLogFormat($logformat);

        $this->assertEquals($logFile, $api->getLogFile());
        $this->assertEquals($logformat, $api->getLogFormat());

        $newClientSecret = "newsecret";
        $newClientId = "newclientid";
        $newApiUrl = "http://newapiurl.com";
        $api->setClientId($newClientId)
            ->setClientSecret($newClientSecret)
            ->setApiUrl($newApiUrl);

        $authHeader = 'Basic '.base64_encode(implode(":", [$newClientId, $newClientSecret]));

        $this->assertEquals($newClientSecret, $api->getClientSecret());
        $this->assertEquals($newClientId, $api->getClientId());
        $this->assertEquals($newApiUrl, $api->getApiUrl());
        $this->assertEquals($authHeader, $api->getAuthorizationHeader());
    }

    public function testGetClientActor()
    {
        $apiUrl = "http://somedummyapi.com";
        $clientId = "some fake id";
        $clientSecret = "some fake secret";

        $returnData = [
            "data" => [
                "access_token" => "sometoken",
                "expires_in" => 10000
            ]
        ];

        $api = new Api($apiUrl, $clientId, $clientSecret);
        $caller = $this->getCallerMock($returnData);
        $caller->shouldReceive('getActor')
            ->andReturn($api);
        $api->setCaller($caller);

        $client = $api->getClientActor();
        $this->assertInstanceOf(Client::class, $client);

        $this->assertEquals($api, $client->getApi());
    }

    public function testGetUserActor()
    {
        $apiUrl = "http://somedummyapi.com";
        $clientId = "some fake id";
        $clientSecret = "some fake secret";

        $returnData = [
            "data" => [
                "token_data" => [
                    "access_token" => "sometoken",
                    "expires_in" => 10000,
                    "refresh_token" => "somerefreshtoken"
                ],
                "user" => [
                    'id' => 1
                ]
            ]
        ];

        $authType = "password_authentication";
        $authParams = [
            "uid" => "hello@mobnia.com",
            "password" => "fakepassword"
        ];

        $api = new Api($apiUrl, $clientId, $clientSecret);
        $caller = $this->getCallerMock($returnData);
        $caller->shouldReceive('getActor')
            ->andReturn($api);
        $api->setCaller($caller);

        $user = $api->getUserActor($authType, $authParams);
        $this->assertInstanceOf(User::class, $user);

        $this->assertEquals($api, $user->getApi());
    }
}
