# Available Routes

The list of available routes are given below.

With an appropriate caller i.e an `Actor` or `Api` object, a call to a route is made as follows:
```php
$caller->{route_group}->{methodName}($payload);
```

The route listing below is grouped according to the route categories and `route_group` is the 
[camelized](https://en.wikipedia.org/wiki/Camel_case) form of the route category.

Please check the API documentation for the proper parameters to be passed to an endpoint.

Alternatively you can call:
```php

# prints the route definition for {methodName} in {RouteCategory}
# print_r(\Olympus\Routes\{RouteCategory}:{methodName}());

# e.g to see the parameters for the updateUserProfile request
print_r(\Olympus\Routes\User::updateUserProfile());
```

## Server
| Method Name        | Endpoint | Method |
| ------------- | ------------- | ------- |
| healthCheck | /               | GET |

<br>

## Auth
| Method Name        | Endpoint | Method |
| ------------- | ------------- | ------- |
| getClientToken | /auth/client/token | POST |
| getUserToken | /auth/user/token | POST |
| refreshAccessToken | /auth/token/refresh | POST |
| revokeAccessToken | /auth/token/revoke | POST |

<br>

## Organisation
| Method Name        | Endpoint | Method |
| ------------- | ------------- | ------- |
| create        | /organisations | POST |
| get        | /organisations/{id} | GET |
| update        | /organisations/{id} | PUT |
| inviteUsers        | /organisations/{id}/invites | POST |
| listMembers        | /organisations/{id}/members | GET |
| removeMembers        | /organisations/{id}/members/remove | POST |
| updateMembersRoles        | /organisations/{id}/members/roles | POST |
| listMemberInvites        | /organisations/{id}/invites | GET |
| getSettings        | /organisations/{id}/settings | GET |
| updateSettings        | /organisations/{id}/settings | PUT |
| respondToInvite        | /organisations/invites/respond | POST |

<br>

## User
| Method Name        | Endpoint | Method |
| ------------- | ------------- | ------- |
| register        | /auth/user/register | POST |
| listUserOrganisations        | /users/{id}/organisations | GET |
| listUserOrganisationInvites        | /users/{id}/organisations/invites | GET |
| getUserProfile        | /users/{id} | GET |
| updateUserProfile        | /users/{id} | PUT |



<br>
