<?php

namespace Olympus\Routes;

class Organisation implements RouteInterface
{

    public static function root()
    {
        return '/organisations';
    }

    public static function create()
    {
        return [
            self::METHOD_KEY => self::POST_METHOD,
            self::ENDPOINT_KEY => self::root(),
            self::PARAMS_KEY => [
                'owner_id',
                'name',
                'description',
                'logo_url'
            ],
            self::REQUIRED_KEY => [
                RouteInterface::PARAMS_KEY => [
                    'owner_id',
                    'name'
                ]
            ],
            self::ACTOR_UID_MAP => [
                RouteInterface::PARAMS_KEY => 'owner_id'
            ]
        ];
    }

    public static function get()
    {
        return [
            self::METHOD_KEY => self::GET_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}',
            self::PATH_KEY => [
                'id'
            ],
            self::REQUIRED_KEY => [
                self::PATH_KEY => [
                    'id'
                ]
            ]
        ];
    }

    public static function update()
    {
        return [
            self::METHOD_KEY => self::PUT_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}',
            self::PATH_KEY => [
                'id'
            ],
            self::PARAMS_KEY => [
                'name',
                'description',
                'logo_url'
            ],
            self::REQUIRED_KEY => [
                self::PATH_KEY => [
                    'id'
                ]
            ]
        ];
    }

    public static function inviteUsers()
    {
        return [
            self::METHOD_KEY => self::POST_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}/invites',
            self::PATH_KEY => [
                'id'
            ],
            self::PARAMS_KEY => [
                'members'
            ],
            self::REQUIRED_KEY => [
                self::PATH_KEY => [
                    'id'
                ],
                self::PARAMS_KEY => [
                    'members'
                ]
            ]
        ];
    }

    public static function listMembers()
    {
        return [
            self::METHOD_KEY => self::GET_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}/members',
            self::PATH_KEY => [
                'id'
            ],
            self::REQUIRED_KEY => [
                self::PATH_KEY => [
                    'id'
                ],
            ]
        ];
    }

    public static function removeMembers()
    {
        return [
            self::METHOD_KEY => self::POST_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}/members/remove',
            self::PATH_KEY => [
                'id'
            ],
            self::PARAMS_KEY => [
                'members'
            ],
            self::REQUIRED_KEY => [
                self::PATH_KEY => [
                    'id'
                ],
                self::PARAMS_KEY => [
                    'members'
                ]
            ]
        ];
    }

    public static function updateMembersRoles()
    {
        return [
            self::METHOD_KEY => self::POST_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}/members/roles',
            self::PATH_KEY => [
                'id'
            ],
            self::PARAMS_KEY => [
                'members'
            ],
            self::REQUIRED_KEY => [
                self::PATH_KEY => [
                    'id'
                ],
                self::PARAMS_KEY => [
                    'members'
                ]
            ]
        ];
    }

    public static function listMemberInvites()
    {
        return [
            self::METHOD_KEY => self::GET_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}/invites',
            self::PATH_KEY => [
                'id'
            ],
            self::REQUIRED_KEY => [
                self::PATH_KEY => [
                    'id'
                ]
            ]
        ];
    }

    public static function getSettings()
    {
        return [
            self::METHOD_KEY => self::GET_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}/settings',
            self::PATH_KEY => [
                'id'
            ],
            self::REQUIRED_KEY => [
                self::PATH_KEY => [
                    'id'
                ]
            ]
        ];
    }

    public static function updateSettings()
    {
        return [
            self::METHOD_KEY => self::PUT_METHOD,
            self::ENDPOINT_KEY => self::root().'/{id}/settings',
            self::PATH_KEY => [
                'id'
            ],
            self::PARAMS_KEY => [
                'member_management_access',
                'settings_management_access',
                'role_management_access'
            ],
            self::REQUIRED_KEY => [
                self::PATH_KEY => [
                    'id'
                ],
                self::PARAMS_KEY => [
                    'member_management_access',
                    'settings_management_access',
                    'role_management_access'
                ]
            ]
        ];
    }

    public static function respondToInvite()
    {
        return [
            self::METHOD_KEY => self::POST_METHOD,
            self::ENDPOINT_KEY => self::root().'/invites/respond',
            self::PARAMS_KEY => [
                'organisation_id',
                'user_id',
                'invite_response'
            ],
            self::REQUIRED_KEY => [
                self::PARAMS_KEY => [
                    'organisation_id',
                    'user_id',
                    'invite_response'
                ]
            ],
            self::ACTOR_UID_MAP => [
                RouteInterface::PARAMS_KEY => 'user_id'
            ]
        ];
    }
}
