<?php


namespace Olympus\Routes;

class Auth implements RouteInterface
{
    public static function root()
    {
        return '/auth';
    }

    public static function getClientToken()
    {
        return [
            self::METHOD_KEY => self::POST_METHOD,
            self::ENDPOINT_KEY => self::root().'/client/token',
            self::REQUIRES_AUTH => true
        ];
    }

    public static function getUserToken()
    {
        return [
            self::METHOD_KEY => self::POST_METHOD,
            self::ENDPOINT_KEY => self::root().'/user/token',
            self::PARAMS_KEY => [
                'auth_type',
                'auth_params',
                'scopes'
            ],
            self::REQUIRED_KEY => [
                self::PARAMS_KEY => [
                    'auth_type',
                    'auth_params',
                    'scopes'
                ]
            ],
            self::DEFAULT_KEY => [
                RouteInterface::PARAMS_KEY => [
                    'scopes' => 'read write'
                ]
            ],
            self::REQUIRES_AUTH => true
        ];
    }

    public static function refreshAccessToken()
    {
        return [
            self::METHOD_KEY => self::POST_METHOD,
            self::ENDPOINT_KEY => self::root().'/token/refresh',
            self::PARAMS_KEY => [
                'refresh_token',
                'scopes'
            ],
            self::REQUIRED_KEY => [
                self::PARAMS_KEY => [
                    'refresh_token',
                    'scopes'
                ]
            ],
            self::DEFAULT_KEY => [
            ],
            self::REQUIRES_AUTH => true
        ];
    }

    public static function revokeAccessToken()
    {
        return [
            self::METHOD_KEY => self::POST_METHOD,
            self::ENDPOINT_KEY => self::root().'/token/revoke',
            self::PARAMS_KEY => [
                'access_token'
            ],
            self::REQUIRED_KEY => [
                self::PARAMS_KEY => [
                    'access_token'
                ]
            ],
            self::REQUIRES_AUTH => true
        ];
    }
}
