<?php


namespace Olympus\Http;

use Olympus\Exception\OlympusException;
use Olympus\Helpers\RequestBag;

class Router
{
    /**
     * @var string
     */
    private $route;

    /**
     * @var string
     */
    private $route_class;

    /**
     * @var array
     */
    private $methods = [];

    /**
     * @var array
     */
    public static $ROUTES = [
        'auth', 'organisation', 'user', 'server'
    ];

    /**
     * Router constructor.
     * @param string $route
     * @param Caller $caller
     * @throws OlympusException
     */
    public function __construct(string $route, Caller $caller)
    {
        if (!in_array($route, Router::$ROUTES)) {
            throw new OlympusException(
                "Route '{$route}' does not exist."
            );
        }

        $this->route = strtolower($route);
        $this->route_class = 'Olympus\\Routes\\' . ucwords($route);

        $mets = get_class_methods($this->route_class);
        if (empty($mets)) {
            throw new OlympusException('Route "' . $this->route . '" does not exist.');
        }
        // add methods to this object per method, except root
        foreach ($mets as $mtd) {
            if ($mtd === 'root') {
                continue;
            }
            $mtdFunc = function (
                RequestBag $params = null
            ) use (
                $mtd,
                $caller
            ) {
                $interface = call_user_func($this->route_class . '::' . $mtd);
                return $caller->callEndpoint($interface, $params);
            };

            $this->methods[$mtd] = \Closure::bind($mtdFunc, $this, get_class());
        }
    }

    public function __call($method, $params)
    {
        if (array_key_exists($method, $this->methods) && is_callable($this->methods[$method])) {
            return call_user_func_array($this->methods[$method], $params);
        } else {
            throw new \Exception('Function "' . $method . '" does not exist for "' . $this->route . '".');
        }
    }
}
