<?php


namespace Olympus\Helpers;


use Olympus\Routes\RouteInterface;

class RequestBag
{
    public $pathParams;
    public $queryParams;
    public $bodyParams;

    public function __construct($pathParams = [], $queryParams = [], $bodyParams = [])
    {
        $this->pathParams = new Bag($pathParams);
        $this->queryParams = new Bag($queryParams);
        $this->bodyParams = new Bag($bodyParams);
    }

    public function setParams($type, $params = [])
    {
        switch ($type) {
            case RouteInterface::PARAMS_KEY:
                $this->bodyParams->reset($params);
                break;
            case RouteInterface::QUERY_PARAMS_KEY:
                $this->queryParams->reset($params);
                break;
            case RouteInterface::PATH_KEY;
                $this->pathParams->reset($params);
        }
    }

    public function updateParams($type, $params = [])
    {
        switch ($type) {
            case RouteInterface::PARAMS_KEY:
                $this->bodyParams->update($params);
                break;
            case RouteInterface::QUERY_PARAMS_KEY:
                $this->queryParams->update($params);
                break;
            case RouteInterface::PATH_KEY;
                $this->pathParams->update($params);
        }
    }

    public function getParams($type)
    {
        switch ($type) {
            case RouteInterface::PARAMS_KEY:
                return $this->bodyParams;
            case RouteInterface::QUERY_PARAMS_KEY:
                return $this->queryParams;
            case RouteInterface::PATH_KEY;
                return $this->pathParams;
        }

        return [];
    }
}
